/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import java.net.URL;
import net.ftb.data.TexturePack;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.TexturepackPane;
import net.ftb.log.Logger;
import net.ftb.util.AppUtils;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TexturePackLoader
extends Thread {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Benchmark.start("TexturepackLoader");
            Logger.logInfo("loading texture pack information...");
            Document doc = AppUtils.downloadXML(new URL(DownloadUtils.getStaticCreeperhostLink("texturepack.xml")));
            if (doc == null) {
                Logger.logError("Error: Could not load texture pack data!");
            }
            NodeList texturePacks = doc.getElementsByTagName("texturepack");
            for (int i = 0; i < texturePacks.getLength(); ++i) {
                Node texturePack = texturePacks.item(i);
                NamedNodeMap textureAttr = texturePack.getAttributes();
                TexturePack.addTexturePack(new TexturePack(textureAttr.getNamedItem("name").getTextContent(), textureAttr.getNamedItem("author").getTextContent(), textureAttr.getNamedItem("version").getTextContent(), textureAttr.getNamedItem("url").getTextContent(), textureAttr.getNamedItem("logo").getTextContent(), textureAttr.getNamedItem("image").getTextContent(), textureAttr.getNamedItem("mcversion").getTextContent(), textureAttr.getNamedItem("compatible").getTextContent(), textureAttr.getNamedItem("description") == null ? null : textureAttr.getNamedItem("description").getTextContent().replace("\\n", "\n"), textureAttr.getNamedItem("resolution").getTextContent(), i));
            }
        }
        catch (Exception e) {
            Logger.logError("Error loading texture pack info", e);
        }
        finally {
            TexturepackPane.loaded = true;
            Benchmark.logBenchAs("TexturepackLoader", "Texture Pack Load ");
            LaunchFrame.checkDoneLoading();
        }
    }
}

